#!/usr/bin/env python
# -*- coding: utf-8

import re

class TemplatedParser:
    def __init__(self, template="", text=""):
        self._data = {}
        self.setTemplate(template)
        self.setText(text)

    def setTemplate(self, template):
        self._template = template

    def setText(self, text):
        self._text = text

    def parse(self):
        pl = self._parse()
        tl = len(self._text)
        if pl != tl:
            raise RuntimeError("Parse error: parsed %s of %s bytes" % (pl, tl))
        return pl

    def _parse(self, pos = 0):
        text_pos = 0;
        while pos < len(self._template):
            parseFn = {
                  "[": self.parseOptional,
                  "<": self.parseOr,
                  "{": self.parseArray,
                }.get(self._template[pos], self.parseFlat)
            pos, text_pos = parseFn(pos, text_pos)
        return text_pos

    def parseFlat(self, pos, text_pos):
        if self._template[pos] == "$":
            pos+=1
            varname = ""
            if self._template[pos] == "(":
                end_pos_varname = self.findPair(pos, pairs={"(":")"})
                varname=self._template[pos+1:end_pos_varname]
                pos=end_pos_varname+1
            else:
                varname=self._template[pos]
                pos+=1
            varval = re.match("[\d.]+", self._text[text_pos:])
            if varval.start() != 0:
                raise RuntimeError("Extarxt data error: start extract position != 0", varval.start())
            text_pos+=varval.end()
            self._data[varname] = varval.group()
        else:
            if self._template[pos] != self._text[text_pos]:
                raise RuntimeError("Template or data error", self._template[pos], self._text[text_pos])
            pos+=1
            text_pos+=1
        return pos, text_pos

    def parseOptional(self, pos, text_pos):
        pair_pos = self.findPair(pos)
        try:
            sub_parser = TemplatedParser(self._template[pos+1:pair_pos], self._text[text_pos:])
            text_pos += sub_parser._parse()
            self._data.update(sub_parser._data)
        except Exception, ex:
            pass
        pos = pair_pos+1
        return pos, text_pos

    def parseOr(self, pos, text_pos):
        pair_pos = self.findPair(pos)
        templates = re.split("\|", self._template[pos+1:pair_pos])

        sub_text_pos = None
        for t in templates:
            try: # try except if parse error for current template
                sub_parser = TemplatedParser(t, self._text[text_pos:])
                sub_text_pos = sub_parser._parse()
                self._data.update(sub_parser._data)
                break
            except Exception, ex:
                pass
        if not sub_text_pos:
            raise RuntimeError("OR: Not found matched")
    
        text_pos += sub_text_pos
        pos = pair_pos+1
        return pos, text_pos

    def parseArray(self, pos, text_pos):
        pair_pos = self.findPair(pos)
        try:
            while True:
                sub_parser = TemplatedParser(self._template[pos+1:pair_pos], self._text[text_pos:])
                text_pos+= sub_parser._parse()
                key = ""
                if not self._data.has_key(key): self._data[key] = []
                self._data[key].append(sub_parser._data)
        except Exception, ex:
            pass

        pos = pair_pos+1
        return pos, text_pos

    def findPair(self, pos, pairs = { "[" : "]", "<" : ">", "{" : "}" }):
        if pos >= len(self._template):
            raise RuntimeError("position > length of template")

        if not self._template[pos] in pairs:
            raise RuntimeError("no such pairs for '" + self._template[pos] + "'")

        stack = []
        stack.append(self._template[pos])

        while len(stack):
            pos += 1
            if pos >= len(self._template):
                raise RuntimeError("In template not found pair for '" + stack[-1] + "'", stack)
            t = self._template[pos]
            if t in pairs:
                stack.append(t)
                continue
            if t == pairs[stack[-1]]:
                stack.pop()
                continue

        return pos
