#!/usr/bin/env python
# -*- coding: utf-8

import re
import tparser;

class Libri:
    COMMENT="**"
    COMMAND="* "
    HEAD=COMMAND + "LIBRI"

    def __init__(self, type, hdr_length, filename):
        self.type = type
        self.hdr_length = hdr_length
        self.filename = filename
        self.HeadOptionsPosition = {}
        self.HeadOptions = {}
        self.ImportFormat = {}
        self.ImportTemplate = {}
        self.ExportTemplate = {}
        self._initData()
        pass

    def _initData(self):
        self.Data = {}
        self.Data["Head"] = {"Type": self.type}
        self.Data["Format"] = None
        self.Data["Data"] = {}

    def detectImportFormat(self):
        fd = []
        for fmt in self.ImportFormat:
            ds = self.ImportFormat[fmt]
            if ds[0] == ds[-1] == '@':
                continue
            if re.search(re.sub("\$.", r"[\d\.]+", ds)\
                    .replace("(", "\(").replace(")", "\)")\
                    .replace("<", "(").replace(">", ")"), self._body):
                fd.append(fmt)

        for fmt in self.ImportFormat:
            ds = self.ImportFormat[fmt]
            if ds[0] == ds[-1] == '@':
                cmd = ds[1:-1]
                if cmd[0:4].upper() == "NOT#":
                    arg = cmd[4:]
                    if not arg in fd:
                        fd.append(fmt)
                    continue

        for tpl in self.ImportTemplate:
            ok = False
            if len(tpl) == len(fd):
                ok = True
                for f in fd:
                    if not f in tpl:
                        ok = False
                        break
                if ok:
                    self.Data["Format"] = list(tpl)
                    return tpl

    def loadRawData(self):
        lines = [line.rstrip() for line in open(self.filename) if not line.startswith(self.COMMENT)]
        start = None
        stop = None
        hdr = self.HEAD + " " + self.type
        i = 0
        for line in lines:
            if start != None and line.startswith(self.COMMAND):
                stop = i
                break
            if start == None and line.startswith(hdr):
                start = i
            i += 1
        return ''.join(lines[start:stop])

    def importData(self):
        self._initData()
        rawdata=self.loadRawData()
        self._head = rawdata[:self.hdr_length]
        self._body = rawdata[self.hdr_length:].replace(" ", "")

        for opt in self.HeadOptionsPosition:
            val = self.HeadOptionsPosition[opt]
            self.HeadOptions[opt] = self._head[val[0]-1:val[1]]
            self.Data["Head"].update({opt:self.HeadOptions[opt]})

        fmt = self.detectImportFormat();
        if fmt == None:
            raise RuntimeError("Can not detect import format")
        template = self.ImportTemplate[fmt]
        if not template:
            raise RuntimeError("Not found import template")
        tp = tparser.TemplatedParser(template, self._body)
        tp.parse();
        self.Data["Data"] = tp._data
        return self.Data

