#!/usr/bin/env python
# -*- coding: utf-8

from Cheetah.Template import Template
def convertTemplate(head, body, separate):
    DEFFUN="""#slurp
#def COLUMN($value, $size, $align)
#set $fmt=u'{0:%c%d}' % ($align, $size)
$fmt.format($value)#slurp
#end def
"""

    HEAD=head + '\n' if head else """"""
    SEPARATE=separate + "\n" if separate else """"""
    BODY="""#slurp
#for $param in $data
%s
#end for
"""%body
    return DEFFUN + HEAD + SEPARATE + BODY

def denormalizeData(data):
    out = []
    sub_data = {}
    for d in data:
        if d != '':
            sub_data[d] = unicode(data[d].decode("UTF-8"));
    try:
        for sub_out in data['']:
            for sub_out_data in denormalizeData(sub_out):
                sub_out_data.update(sub_data)
                out.append(sub_out_data)
    except:
        return [sub_data]
    return out

def exportToFile(filename, tpl_body, Data, tpl_head=None, tpl_prologue=None, tpl_epilogue=None, tpl_separate=None):
    f = open(filename, 'w')
    fmt = Data['Format']
    head = Data['Head']
    data = denormalizeData(Data['Data'])
    t = Template(convertTemplate(tpl_head, tpl_body, tpl_separate), searchList={'data':data})
    if tpl_prologue: f.write(tpl_prologue); f.write('\n')
    f.write(str(t))
    if tpl_epilogue: f.write(tpl_epilogue)
    f.close()
    pass
