#!/usr/bin/env python
# -*- coding: utf-8

from generic.libri import Libri
import generic.utils as utils



def importFromLibriFile(filename):
    land2d   = "[TAP$(TAP),][<MOT|WORD>$(ONE),]{(<$A-$B|$A>)={M$MX$X,}[TAP$(TAP),]}"
    marine2d = "[TAP$(TAP),][[<MOT|WORD>$(ONE),]{(IQ$(IQ))={M$MX$X,}(IQ$(IQ))={M$MX$X,}[TAP$(TAP),]}"
    land3d   = "[TAP$(TAP),][<MOT|WORD>$(TWO)={<LINE|LIGNE>$(LINE),[<MOT|WORD>$(ONE),]{(<$A-$B|$A>)={M$MX$X,}[TAP$(TAP),]}}"
    marine3d = "[TAP$(TAP),][<MOT|WORD>$(TWO)={<LINE|LIGNE>$(LINE),{(IQ$(IQ))={M$MX$X,}(IQ$(IQ))={M$MX$X,}[TAP$(TAP),]}}"

    libri = Libri("MU", 30, filename)
    libri.HeadOptionsPosition["LibraryNumber"] = (12, 13)
    libri.ImportFormat["2D"] = "@NOT#3D@"
    libri.ImportFormat["3D"] = "<LINE|LIGNE>$n"
    libri.ImportFormat["ATT"] = "@NOT#WATER@"
    libri.ImportFormat["WATER"] = "(IQ$f)"

    libri.ImportTemplate[("2D", "ATT",)]   = land2d
    libri.ImportTemplate[("3D", "ATT",)]   = land3d
    libri.ImportTemplate[("2D", "WATER",)] = marine2d
    libri.ImportTemplate[("3D", "WATER",)] = marine3d
    data = libri.importData()
    # Workaround ONE
    wa = utils.findFirst(data["Data"], "ONE")
    if wa: data["Data"]["ONE"] = wa;
    # Workaround TAP
    wa = utils.findFirstInAll(data["Data"], "TAP")#TODO need findLastInAll
    if wa: data["Data"]["TAP"] = wa;
    #print data
    return data;

def exportToLibriFile(filename, data):
    land2d   = "WORD$d,{(<$a-$b|$a>)={M$mX$x,}[TAP$t,]}"
    marine2d = "WORD$d,{(IQ$f)={M$mX$x,}(IQ$g)={M$mX$x,}[TAP$t,]}"
    land3d   = "WORD$X={LINE$n,WORD$Y,{(<$a-$b|$a>)={M$mX$x,}[TAP$t,]}}"
    marine3d = "WORD$X={LINE$n,{(IQ$f)={M$mX$x,}(IQ$g)={M$mX$x,}[TAP$t,]}}"

    libri = Libri("MU", 30, filename);
    libri.HeadOptionsPosition["LibraryNumber"] = (12, 13)

    libri.ExportTemplate[("2D", "ATT",)]   = land2d
    libri.ExportTemplate[("3D", "ATT",)]   = land3d
    libri.ExportTemplate[("2D", "WATER",)] = marine2d
    libri.ExportTemplate[("3D", "WATER,")] = marine3d
    libri.exportData()

ImportFileFilters = "Libri MU files (*.lmu)"
def importFromFile(filename):
    if filename.endswith(".lmu"):
        return importFromLibriFile(filename)
    raise RuntimeError("Not supported import file format")

ExportFileFilters = "Libri MU files (*.lmu)"

def exportToFile(filename, data):
    if filename.endswith(".lmu"):
        return exportToLibriFile(filename, data)
    raise RuntimeError("Not supported export file format")
